package gov.va.genisis2.converter;

import static org.junit.Assert.assertEquals;

import org.junit.Before;
import org.junit.Test;

import gov.va.genisis2.AbstractMockMvcTests;
import gov.va.genisis2.model.UserRefreshHistory;

/**
 * 
 * @author Getaneh Kassahun
 * 
 */
public class UserRefreshHistoryConverterTest extends AbstractMockMvcTests {

	/** The userRefreshHistoryConverter. */
	private UserRefreshHistoryConverter userRefreshHistoryConverter;

	/** The userRefreshHistory. */
	private UserRefreshHistory userRefreshHistory;

	/** Run before all test methods. */
	@Before
	public void setUp() {
		userRefreshHistoryConverter = new UserRefreshHistoryConverter();
	}

	/**
	 * To testPopulateUserRefreshHistory_Username.
	 * 
	 */
	@Test
	public void testPopulateUserRefreshHistory_Username() {
		userRefreshHistory = userRefreshHistoryConverter.populateUserRefreshHistory("NightlyJob");
		assertEquals("NightlyJob", userRefreshHistory.getScheduledBy());

	}

	/**
	 * To testPopulateUserRefreshHistory_UserRefreshHistory.
	 * 
	 */
	@Test
	public void testPopulateUserRefreshHistory_UserRefreshHistory() {
		userRefreshHistory = userRefreshHistoryConverter.populateUserRefreshHistory("NightlyJob");
		assertEquals("NightlyJob", userRefreshHistoryConverter.populateUserRefreshHistory(userRefreshHistory).getScheduledBy());

		userRefreshHistory = userRefreshHistoryConverter.populateUserRefreshHistory(userRefreshHistory, "errorMessage");
		assertEquals("errorMessage", userRefreshHistory.getErrorMessage());
	}

}
